###################################################################################################
##################################       read in data    ##########################################
###################################################################################################
cccol <- c("#CE0013","#16557A","#C7A609","#87C232","#64C0AB","#A14C94","#15A08C","#8B7E75","#1E7CAF","#EA425F","#46489A","#E50033","#0F231F","#1187CD")

n_hiFT <- read.table("../data/niPS_specific_hiFT_AverageMethyRatio.txt",header=T,row.names=1)
n_he6 <- read.table("../data/niPS_specific_he6_AverageMethyRatio.txt",header=T,row.names=1)
n_n20 <- read.table("../data/niPS_specific_n20_AverageMethyRatio.txt",header=T,row.names=1)
n_n24_r1 <- read.table("../data/niPS_specific_n24_r1_AverageMethyRatio.txt",header=T,row.names=1)
n_n24_r2 <- read.table("../data/niPS_specific_n24_r2_AverageMethyRatio.txt",header=T,row.names=1)
n_niPS <- read.table("../data/niPS_specific_niPS_AverageMethyRatio.txt",header=T,row.names=1)
n_p20 <- read.table("../data/niPS_specific_p20_AverageMethyRatio.txt",header=T,row.names=1)
n_p20_r2 <- read.table("../data/niPS_specific_p20_r2_AverageMethyRatio.txt",header=T,row.names=1)
n_p24 <- read.table("../data/niPS_specific_p24_AverageMethyRatio.txt",header=T,row.names=1)
n_p24_r2 <- read.table("../data/niPS_specific_p24_r2_AverageMethyRatio.txt",header=T,row.names=1)
n_piPS <- read.table("../data/niPS_specific_piPS_AverageMethyRatio.txt",header=T,row.names=1)
n_n24 <- apply(cbind(n_n24_r1,n_n24_r2),1,mean,na.rm=T)
n_p20 <- apply(cbind(n_p20,n_p20_r2),1,mean,na.rm=T)
n_p24 <- apply(cbind(n_p24,n_p24_r2),1,mean,na.rm=T)

naive_path <- c("hiF-T","6d","20d","24d","niPSC-T")
primed_path <- c("hiF-T","6d","20d","24d","piPSC-T")
common_path <- c("hiF-T","6d","20d","24d","iPSC-T")

n_dmr_npath <- cbind(n_hiFT,n_he6,n_n20,n_n24,n_niPS)
n_dmr_ppath <- cbind(n_hiFT,n_he6,n_p20,n_p24,n_piPS)


###################################################################################################
###############################     boxplot of specific DMR(NA removed)   #########################
###################################################################################################
n_dmr_npath_re <- na.omit(n_dmr_npath)
n_dmr_ppath_re <- na.omit(n_dmr_ppath)

pdf("Fig5D.pdf",width=3,height=4)
par(mar=c(6,4,4,2))
n <- length(naive_path)
boxplot(n_dmr_npath_re, at=0:(n-1)*3 + 1, xlim=c(0,n*3), xaxt="n", outline=F,main="naive specific DMR",ylab="DNA methylation ratio",xlab="",col=cccol[1],ylim=c(0,1),las=2)
boxplot(n_dmr_ppath_re, at=0:(n-1)*3+2, xaxt="n",yaxt="n", add=TRUE, outline=F,col=cccol[2],ylim=c(0,1))
axis(1, at = 0:(n-1)*3 + 1.5, labels = common_path, tick = TRUE, las=2)
dev.off()
